// Cloud Shader by Alexander Plloth ('Kartoffel')

float pass_strength = 1.0f;
float alpha_add = 0.25f;

// Definitions
texture entSkin1;
texture entSkin2;
texture entSkin3;
texture entSkin4;

float4 vecTime;

float4 vecColor;

float fAlpha;
float fAlbedo;

// Sampler
sampler base_sampler = sampler_state
{ Texture = <entSkin1>; AddressU = wrap; AddressV = wrap; };

sampler pass_123_sampler = sampler_state
{ Texture = <entSkin2>; AddressU = wrap; AddressV = wrap; };

sampler pass_456_sampler = sampler_state
{ Texture = <entSkin3>; AddressU = wrap; AddressV = wrap; };

sampler alpha_pass_sampler = sampler_state
{ Texture = <entSkin4>;};

// Pixelshader
float4 PS_clouds(
	float4 inTex: TEXCOORD0
):COLOR
{
	//// create all layers
	float4 base;
	base = tex2D(base_sampler,inTex.xy + float2(vecTime.w*0.1f*fAlbedo / 1500.0f,0));
	float cloud_base = base.b;
	
	float4 tex;
	tex = tex2D(pass_123_sampler,inTex.xy + float2(vecTime.w*0.21f*fAlbedo / 1500.0f + 0.42f,-vecTime.w*0.033f*fAlbedo / 1500.0f + 0.2f));
	float pass1 = (1.0f - tex.r) * pass_strength; // invert and multiply with pass_strength
	
	tex = tex2D(pass_123_sampler,inTex.xy + float2(vecTime.w*0.17f*fAlbedo / 1500.0f - 0.62f,vecTime.w*0.072f*fAlbedo / 1500.0f - 0.14f));
	float pass2 = (1.0f - tex.g) * pass_strength;
	
	tex = tex2D(pass_123_sampler,inTex.xy + float2(vecTime.w*0.034f*fAlbedo / 1500.0f + 0.22f,-vecTime.w*0.045f*fAlbedo / 1500.0f + 0.15f));
	float pass3 = (1.0f - tex.b) * pass_strength;
	
	tex = tex2D(pass_456_sampler,inTex.xy + float2(vecTime.w*0.023f*fAlbedo / 1500.0f + 0.15f,vecTime.w*0.083f*fAlbedo / 1500.0f - 0.77f));
	float pass4 = (1.0f - tex.r) * pass_strength;
	
	tex = tex2D(pass_456_sampler,inTex.xy + float2(vecTime.w*0.062f*fAlbedo / 1500.0f - 0.77f,-vecTime.w*0.032f*fAlbedo / 1500.0f + 0.15f));
	float pass5 = (1.0f - tex.g) * pass_strength;
	
	tex = tex2D(pass_456_sampler,inTex.xy + float2(vecTime.w*0.051f*fAlbedo / 1500.0f + 0.2f,vecTime.w*0.047f*fAlbedo / 1500.0f + 0.22f));
	float pass6 = (1.0f - tex.b) * pass_strength;
	
	tex = tex2D(base_sampler,inTex.xy + float2(vecTime.w*0.17f*fAlbedo / 1500.0f + 0.15f,-vecTime.w*0.053f*fAlbedo / 1500.0f - 0.62f));
	float pass7 = (1.0f - tex.g) * pass_strength;
	
	tex = tex2D(base_sampler,inTex.xy + float2(vecTime.w*0.12f*fAlbedo / 1500.0f - 0.14f,-vecTime.w*0.084f*fAlbedo / 1500.0f + 0.42f));
	float pass8 = (1.0f - tex.b) * pass_strength;
	
	float4 alpha_pass;
	alpha_pass = tex2D(alpha_pass_sampler,inTex.xy);
	
	////
	
	base.a = (cloud_base - pass1 * 0.5f - pass2 * 0.5f - pass3 * 0.5f - pass4 * 0.5f - pass5 * 0.5f - pass6 * 0.5f - pass7 * 0.5f * pass8 * 0.5);
	base.a += alpha_add;
	base.rgb = 1.0f; // White color
	
	// you can play with these values
	base.a = ((base.a - 0.3f) * 3.5f) + 0.3f; // Alpha sharp
//	base.a = ((base.a - 0.1f) * 3.5f) + 0.1f; // Alpha sharp (more visible)
//	base.a = ((base.a - 0.3f) * 5.0f) + 0.3f; // Alpha sharp (sharper)
	
	base.a *= fAlpha;
	
	base.a = base.a * alpha_pass.r;
	base.rgb *= vecColor.rgb; // Use color
	
	return base;
}


technique PP
{
	pass p0
	{
		PixelShader = compile ps_2_0 PS_clouds();
		VertexShader = NULL;
	}
}